---------------------------------------------------------------------------------------------
-- Creates a defence army for steppe robbery outpost
function CreateArmyOne()
	AI.Player_EnableAi(2)
	LeftCampDef = UnlimitedArmy:New({
			Player = 2,
			Area = 3800,
			AutoDestroyIfEmpty = true,
			TransitAttackMove = true,
			Formation = UnlimitedArmy.Formations.Circle,
			LeaderFormation = FormationFunktion,
			AIActive = true,
			AutoRotateRange = 100000,
			DoNotNormalizeSpeed = true
	})
	local spawntable = {}
	spawntable[1] = GetPosition("P2_SpawnPoint_1")
	spawntable[1].Generator = "P2_RobberyTower_1"
	spawntable[2] = GetPosition("P2_SpawnPoint_5")
	spawntable[2].Generator = "P2_RobberyTower_5"
	LeftCampDefSpawner = UnlimitedArmySpawnGenerator:New(LeftCampDef,{
		Position = spawntable,
		ArmySize = 16,
		SpawnCounter = 5,
		SpawnLeaders = 8,
		LeaderDesc = {
			{LeaderType = Entities.PV_Cannon3, SoldierNum = 0, SpawnNum = 2, Looped = true, Experience = 3},
			{LeaderType = Entities.PU_LeaderRifle1, SoldierNum = 4, SpawnNum = 4, Looped = true, Experience = 3},
			{LeaderType = Entities.PU_LeaderBow2, SoldierNum = 8, SpawnNum = 3, Looped = true, Experience = 3},
			{LeaderType = Entities.PU_LeaderPoleArm3, SoldierNum = 8, SpawnNum = 1, Looped = true, Experience = 3},
			{LeaderType = Entities.PU_LeaderCavalry2, SoldierNum = 3, SpawnNum = 2, Looped = true, Experience = 3},
			{LeaderType = Entities.PU_LeaderSword4, SoldierNum = 8, SpawnNum = 4, Looped = true, Experience = 3}
		},
		RandomizeSpawnPoint = true
	})
	LeftCampDef:AddCommandMove(GetPosition("P2_SpawnPoint_5"),true)
	LeftCampDef:AddCommandWaitForIdle(true)
	LeftCampDef:AddCommandMove(GetPosition("P2_SpawnPoint_1"),true)
	LeftCampDef:AddCommandWaitForIdle(true)
	
	Logic.SetTechnologyState(2, Technologies.T_LeatherMailArmor, 3)
	Logic.SetTechnologyState(2, Technologies.T_ChainMailArmor, 3)
	Logic.SetTechnologyState(2, Technologies.T_PlateMailArmor, 3)
	Logic.SetTechnologyState(2, Technologies.T_SoftArcherArmor, 3)
	Logic.SetTechnologyState(2, Technologies.T_PaddedArcherArmor, 3)
	Logic.SetTechnologyState(2, Technologies.T_LeatherArcherArmor, 3)
	Logic.SetTechnologyState(2, Technologies.T_MasterOfSmithery, 3)
	Logic.SetTechnologyState(2, Technologies.T_Fletching, 3)
	Logic.SetTechnologyState(2, Technologies.T_WoodAging, 3)
	Logic.SetTechnologyState(2, Technologies.T_EnhancedGunPowder, 3)
	Logic.SetTechnologyState(2, Technologies.T_BlisteringCannonballs, 3)
	Logic.SetTechnologyState(2, Technologies.T_BetterTrainingBarracks, 3)
	Logic.SetTechnologyState(2, Technologies.T_BetterTrainingArchery, 3)
	Logic.SetTechnologyState(2, Technologies.T_Shoeing, 3)
	Logic.SetTechnologyState(2, Technologies.T_Masonry, 3)
	Logic.SetTechnologyState(2, Technologies.T_FleeceArmor, 3)
	Logic.SetTechnologyState(2, Technologies.T_FleeceLinedLeatherArmor, 3)
	Logic.SetTechnologyState(2, Technologies.T_LeadShot, 3)
	Logic.SetTechnologyState(2, Technologies.T_Sights, 3)
end

FormationFunktion = function(self, truppid)
	if Logic.IsEntityInCategory(truppid, EntityCategories.Cannon)==1 then
		return 1
	end
	if Logic.IsEntityInCategory(truppid, EntityCategories.Hero)==1 then
		return 1
	end
	if Logic.IsEntityInCategory(truppid, EntityCategories.CavalryHeavy)==1 then
		return 7
	end
	if Logic.IsEntityInCategory(truppid, EntityCategories.CavalryLight)==1 then
		return 2
	end
	if Logic.IsEntityInCategory(truppid, EntityCategories.Bow)==1 or Logic.IsEntityInCategory(truppid, EntityCategories.Rifle)==1 then
		return 2
	end
	if Logic.IsEntityInCategory(truppid, EntityCategories.Spear)==1 then
		return 6
	end
	if Logic.IsEntityInCategory(truppid, EntityCategories.Sword)==1 then
		return 4
	end
	return 1
end